import { useState, useEffect } from 'react'
import { ChevronLeft, ChevronRight } from 'lucide-react'
import sewing1 from '/images/sewing-1.jpg'
import sewing2 from '/images/sewing-2.jpg'
import sewing3 from '/images/sewing-3.jpg'
import sewing4 from '/images/sewing-4.jpg'
import './ImageSlider.css'

const ImageSlider = () => {
  const [currentIndex, setCurrentIndex] = useState(0)
  
  // Заглушки для изображений
  const images = [
    {
      id: 1,
      src: sewing1,
      title: 'Шитье'
    },
    {
      id: 2,
      src: sewing2,
      title: 'Кройка'
    },
    {
      id: 3,
      src: sewing3,
      title: 'Дизайн'
    },
    {
      id: 4,
      src: sewing4,
      title: 'Стиль'
    }
  ]

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentIndex((prev) => (prev + 1) % images.length)
    }, 3000)

    return () => clearInterval(interval)
  }, [images.length])

  const goToPrevious = () => {
    setCurrentIndex((prev) => (prev - 1 + images.length) % images.length)
  }

  const goToNext = () => {
    setCurrentIndex((prev) => (prev + 1) % images.length)
  }

  const goToSlide = (index) => {
    setCurrentIndex(index)
  }

  return (
    <div className="slider-container-modern">
      <div className="slider-wrapper-modern">
        {images.map((img, index) => (
          <div
            key={img.id}
            className={`slide-modern ${index === currentIndex ? 'active' : ''}`}
          >
            <img src={img.src} alt={img.title} className="slide-image-modern" />
            <div className="slide-overlay-modern"></div>
            <div className="slide-content-modern">
              <h3 className="slide-title-modern">{img.title}</h3>
            </div>
          </div>
        ))}
      </div>
      <button className="slider-btn-modern prev-modern" onClick={goToPrevious}>
        <ChevronLeft className="slider-icon-modern" size={24} />
      </button>
      <button className="slider-btn-modern next-modern" onClick={goToNext}>
        <ChevronRight className="slider-icon-modern" size={24} />
      </button>
      <div className="slider-dots-modern">
        {images.map((_, index) => (
          <button
            key={index}
            className={`dot-modern ${index === currentIndex ? 'active' : ''}`}
            onClick={() => goToSlide(index)}
            aria-label={`Go to slide ${index + 1}`}
          />
        ))}
      </div>
    </div>
  )
}

export default ImageSlider

